<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment\Like;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\Post\PostCommentLikeTable;

final class PostCommentLikeFinder extends AbstractFinder implements InterfacePostCommentLikeSetter
{
    /**
     * setter interface
     */
    use TraitPostCommentLikeSetters;

    public function getTableName(): string
    {
        return PostCommentLikeTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {PostCommentLikeTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): PostCommentLikeModel
    {
        return PostCommentLikeModel::createFromUntouchedBean_noException(parent::pop());
    }
}
